
'use client';
import { useLocale } from 'next-intl';
import { Dispatch, SetStateAction } from 'react';
interface LocalizedText {
  ar: string;
  en: string;
}


interface PageHeaderItem {
  id: number;
  title: LocalizedText;
  description: LocalizedText;
  media: string;
  type: string;
  mediaAction: Dispatch<SetStateAction<number>>;
  active: boolean
}

export default function MediaItem(props: PageHeaderItem) {
  const { id, title, description, type, media, mediaAction,active } = props;
  const locale = useLocale() as 'ar' | 'en';


  return (
    <>
      {
        type == "image" ? <><img onClick={()=>mediaAction(id)} className={`w-1/4 h-auto flex rounded-2xl cursor-pointer ${active?"border-2 border-main-orange":""}`} src={media} title={title[locale || "ar"]} alt={title[locale || "ar"]} /></> : <></>
      }
    </>
  )
}